/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.net.URL;
import javax.swing.ProgressMonitor;
import skeletonapplet.AbstractFileInfo;
import skeletonapplet.FileInfo;
import skeletonapplet.Utilities;

public class AtomicDownloader {
    protected URL baseUrl;
    protected AbstractFileInfo fileInfo;
    protected byte[] downloadedData;

    public AtomicDownloader(URL uRL, String string) {
        this.baseUrl = uRL;
        this.fileInfo = new FileInfo();
        this.fileInfo.parseSpec(string);
    }

    public AtomicDownloader(URL uRL, AbstractFileInfo abstractFileInfo) {
        this.baseUrl = uRL;
        this.fileInfo = abstractFileInfo;
    }

    public byte[] download(ProgressMonitor progressMonitor, int n) {
        return this.download(progressMonitor, n, 1);
    }

    public byte[] download(ProgressMonitor progressMonitor, int n, int n2) {
        if (n2 == 0) {
            return null;
        }
        try {
            this.downloadedData = this.innerDownload(progressMonitor, n);
            if (this.fileInfo.validate(this.downloadedData)) {
                return this.downloadedData;
            }
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        return this.download(progressMonitor, n, n2 - 1);
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public byte[] getDownloadedData() {
        return this.downloadedData;
    }

    public AbstractFileInfo getFileInfo() {
        return this.fileInfo;
    }

    protected byte[] innerDownload(ProgressMonitor progressMonitor, int n) throws Exception {
        URL uRL = new URL(this.baseUrl, this.fileInfo.getDownloadFileName());
        Utilities.logPrintln("??? newUrl = " + uRL);
        return Utilities.downloadBytes(uRL, progressMonitor, n);
    }
}

